%%book to market
by year, sort: egen book_to_marketMS = mean(MS)
by year, sort: egen book_to_marketBAML = mean(BAML)
by year, sort: egen book_to_marketGS = mean(GS)
by year, sort: egen book_to_marketWF = mean(WF)
by year, sort: egen book_to_marketJPM = mean(JPM)

%%vols 
keep if year>= 2002 
keep if year<=2014 

gen voldivWF = WF/SP500
gen voldivC = C/SP500
gen voldivBAML = BAML/SP500
gen voldivJPM = JPM/SP500
gen voldivMS = MS/SP500
gen voldivGS = GS/SP500


gen volmWF = WF-SP500
gen volmC = C-SP500
gen volmBAML = BAML-SP500
gen volmJPM = JPM-SP500
gen volmMS = MS-SP500
gen volmGS = GS-SP500

gen crisis = . 
replace crisis = 0 if year <= 2007 
replace crisis = 1 if year >= 2010 
drop if crisis == . 



by crisis, sort: egen WFdiv = mean(voldivWF)
by crisis, sort: egen Cdiv = mean(voldivC)
by crisis, sort: egen BAMldiv = mean(voldivBAML)
by crisis, sort: egen JPMdiv = mean(voldivJPM)
by crisis, sort: egen MSdiv = mean(voldivGS)
by crisis, sort: egen GSdiv = mean(voldivGS)

by crisis, sort: egen WFm = mean(volmWF)
by crisis, sort: egen Cm = mean(volmC)
by crisis, sort: egen BAMlm = mean(volmBAML)
by crisis, sort: egen JPMm = mean(volmJPM)
by crisis, sort: egen MSm = mean(volmGS)
by crisis, sort: egen GSm = mean(volmGS)

by crisis, sort: egen WFavg = mean(WFC)
by crisis, sort: egen Cavg = mean(C)
by crisis, sort: egen BAMLavg = mean(BAML)
by crisis, sort: egen JPMavg = mean(JPM)
by crisis, sort: egen MSavg = mean(MS)
by crisis, sort: egen GSavg = mean(GS)

by crisis, sort: gen output_indicator = _n
replace output_indicator = 0 if output_indicator != 1

br crisis WFavg Cavg BAMLavg JPMavg MSavg GSavg WFdiv Cdiv BAMldiv JPMdiv MSdiv GSdiv WFm Cm BAMlm JPMm MSm GSm if output_indicator == 1

